<?php

namespace App\Http\Middleware;

use Closure;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\App;
use Symfony\Component\HttpFoundation\Response;

class LanguageSwitcher
{
    /**
     * Handle an incoming request.
     *
     * @param  \Closure(\Illuminate\Http\Request): (\Symfony\Component\HttpFoundation\Response)  $next
     */
    public function handle(Request $request, Closure $next): Response
    {
        $locale = get_option('language', 'en');
        $timezone = get_option('timezone', 'Asia/Karachi');

        App::setLocale($locale);

        // Set the timezone of the application
        config(['app.timezone' => $timezone]);
        date_default_timezone_set($timezone);

       

        return $next($request);
    }
}
